#pragma once

#include <vector>

template <class dType,class dType2> void QuickSort(std::vector<dType>* pArray,long dwLeft,long dwRight)
{
	dType2 dPivot, dChange; //hodnota prvku asi uprostred a toho pro vymenu

	long i,j; //hodnoty indexu, pole nesmi byt unsigned, obcas potrebujeme i zaporne hodnoty

	i = dwLeft; //urcuje konec leve casti pole
	j = dwRight; //urcuje konec prave casti pole
	
	//zvoleni hodnoty pivot bodu
	dPivot = (dType2)(*pArray)[(dwLeft + dwRight) / 2];

	do
	{
		//hledame prvek ktery nepatri na levou stranu pole, tj je vetsi nez zvoleny prvek
		while (*(dType2)(*pArray)[i] < *dPivot)
			i++;
		//takovy prvek byl nalezen, ted hledame prvek ktery je vesti nez dPivot, ten je z prave pulky
		while (*(dType2)(*pArray)[j] > *dPivot)
			j--;

		//ted pokud se indexy neprekrizily, prvky vymenime
		if (i <= j)
		{	
			dChange = (dType2)(*pArray)[i]; //prohozeni prvku
			(*pArray)[i] = (*pArray)[j];
			(*pArray)[j] = dChange;

			//posunuti na dalsi prvky
			i++;
			j--;
        }
	}
	while (i < j); //cyklus konci pokud doslo k prekrizeni indexu, to znamena ze cisla z leve casti ktera jsou vetsi
	//nez vybrany prvek byla vymenena s cisly ktera jsou mensi nez vybrany prvek z casti prave, muzeme pokracovat ve stejnem zpracovani texhto useku

	//pokracujeme v trideni polovin, ale kontrolujeme indexy
	if (dwLeft < j)
		QuickSort<dType,dType2>(pArray,dwLeft,j);

	if (dwRight > i)
		QuickSort<dType,dType2>(pArray,i,dwRight);
}

template <class dType,class dType2> long FindInArray(std::vector<dType> pArray,dType2 Item,long dwLeft,long dwRight)
{
	DWORD	Middle;
	dType2	tmpItem;

	if (pArray.size() < 1)
		return -1;

	Middle = (dwLeft + dwRight) / 2;

	tmpItem = (dType2)pArray[Middle];

	if (dwLeft <= dwRight)
	{
		if (Item > tmpItem)
			return FindFile(pArray,Item,Middle + 1,dwRight);
		if (Item < tmpItem)
			return FindFile(pArray,Item,dwLeft,Middle-1);

		return Middle;
	}
	
	return -1;
}